/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class VariantList
implements IUnbakedModel {
    private final List<Variant> field_188115_a;

    public VariantList(List<Variant> list) {
        this.field_188115_a = list;
    }

    public List<Variant> func_188114_a() {
        return this.field_188115_a;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof VariantList) {
            VariantList variantList = (VariantList)object;
            return this.field_188115_a.equals(variantList.field_188115_a);
        }
        return false;
    }

    public int hashCode() {
        return this.field_188115_a.hashCode();
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        return this.func_188114_a().stream().map(Variant::func_188046_a).collect(Collectors.toSet());
    }

    @Override
    public Collection<RenderMaterial> func_225614_a_(Function<ResourceLocation, IUnbakedModel> function, Set<Pair<String, String>> set) {
        return this.func_188114_a().stream().map(Variant::func_188046_a).distinct().flatMap(resourceLocation -> ((IUnbakedModel)function.apply((ResourceLocation)resourceLocation)).func_225614_a_(function, set).stream()).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public IBakedModel func_225613_a_(ModelBakery modelBakery, Function<RenderMaterial, TextureAtlasSprite> function, IModelTransform iModelTransform, ResourceLocation resourceLocation) {
        if (this.func_188114_a().isEmpty()) {
            return null;
        }
        WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
        for (Variant variant : this.func_188114_a()) {
            IBakedModel iBakedModel = modelBakery.func_217845_a(variant.func_188046_a(), variant);
            builder.func_177677_a(iBakedModel, variant.func_188047_d());
        }
        return builder.func_209614_a();
    }

    public static class Deserializer
    implements JsonDeserializer<VariantList> {
        public VariantList deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            ArrayList arrayList = Lists.newArrayList();
            if (jsonElement.isJsonArray()) {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                if (jsonArray.size() == 0) {
                    throw new JsonParseException("Empty variant array");
                }
                for (JsonElement jsonElement2 : jsonArray) {
                    arrayList.add(jsonDeserializationContext.deserialize(jsonElement2, Variant.class));
                }
            } else {
                arrayList.add(jsonDeserializationContext.deserialize(jsonElement, Variant.class));
            }
            return new VariantList(arrayList);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

